%{
Copyright (c) 2011, MIT.
Developed with the sponsorship of the Defense Advanced Research Projects
Agency (DARPA).

Permission is hereby granted, free of charge, to any person obtaining a copy
of this data, including any software or models in source or binary form, as
well as any drawings, specifications, and documentation (collectively "the
Data"), to deal in the Data without restriction, including without
limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Data, and to permit persons to whom
the Data is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE DATA OR
THE USE OR OTHER DEALINGS IN THE DATA.
%}

% Matt Fitzgerald
% Space Tug Era simulator - survival   (first multiple-arc attempt)

function [Rev Cost transCost ruleUse utilityMonths bestPareto worstPareto avgPareto avgParetoNoFail metContracts missedContracts] = ERA_spaceTug_survive(initialDesign,eraLength,numRules,rulepathP,rulepathF,costpathP,costpathF,MAU,COSTS,fuzzyParetoNumbers)

numEpochs = size(MAU,2);
numDesigns = size(rulepathP,1);

ruleUse = zeros(1,numRules);
transCost = zeros(1,2);
Rev = 0;
Cost = COSTS(initialDesign,1);
utilityMonths = 0;
currTime = 0;
currDesign = initialDesign;
designPath = currDesign;
epochPath = [];
paretoPath = [];
metContracts = 0;
missedContracts = 0;

% pick random time after 5 years for future technology switch
if eraLength <= 60 % remember, time is in months for this dataset
    futureTime = eraLength;
else
    futureTime = round((eraLength-60)*rand(1)) + 60;
end

% set NaN MAUs to -1 (failure)
MAU(isnan(MAU)) = -1;

while currTime < futureTime
    % pick a random customer (epoch) in present time
    currEpoch = round((numEpochs/2)*rand(1) + .5);
    epochPath = [epochPath currEpoch];
    % pick a random duration for their need from 1 to 12 months
    currDuration = round(rand(1)*12 + .5);
    currTime = currTime + currDuration;
    
    
            % determine if transition is necessary
        remainder = mod(currDesign,8);  % 1 == min fuel
        if remainder == 0
            remainder = 8;
        end
        currMAU = MAU(currDesign,currEpoch);    % -1 == inviable
        
        if currMAU == -1
            
            % check if maxing fuel will make viable, do that if so
            if MAU(currDesign-remainder+8,currEpoch) ~= -1 && remainder ~= 8
                pathOptions = costpathP{currDesign,currDesign-remainder+8};
                [~, idx] = sort(pathOptions(:,1));
                pathOptions = pathOptions(idx,:);
                % by the nature of the data set, we know that that fastest
                % possible transition will always be the first row of this
                % pathOptions, so we dont need to loop, just check the one
                if pathOptions(1,2) < currDuration
                    rulesUsed = rulepathP{currDesign,currDesign-remainder+8}{idx(1),:};
                    for r = rulesUsed
                        ruleUse(1,r) = ruleUse(1,r) + 1;
                    end
                    if any(rulesUsed ~= 6)
                        Cost = Cost + COSTS(currDesign-remainder+8,currEpoch);  % ADD REDESIGN/BUILD COST IF A REDESIGN RULE IS USED
                    end
                    Cost = Cost + pathOptions(1,1);  % ADD IN TRANS $ COST AS WELL
                    transCost = transCost + pathOptions(1,:); % INCREMENT TRANS COSTS ($/time)
                    currDuration = currDuration - pathOptions(1,2);  % REDUCE REMAINING DURATION OF THIS EPOCH
                    currDesign = currDesign-remainder+8;  % CHANGE CURRENT DESIGN TO TARGET
                    designPath = [designPath currDesign];
                    
                    % IF this clause is not activated, the design simply
                    % doesn't change
                end
               
            else  % IF INVIABLE AND MAXING FUEL DOES NOT FIX
                % find the maxU available viable design
                
                % find available transitions
                available = [];
                for d2 = 1:numDesigns
                    if ~isempty(costpathP{currDesign,d2})
                        available = [available d2];
                    end
                end
                % find avaiable design with highest MAU
                availableMAU = MAU(available,currEpoch);
                [sortedMAU indices] = sort(availableMAU); % sorts largest = last
                sortedAvailable = available(indices);
                
                % designate as unsolved and loop until solved
                unsolved = 1;
                while unsolved
                    if isempty(sortedAvailable)
                        break
                    end
                    currTarget = sortedAvailable(end);
                    currTargetMAU = sortedMAU(end);
                    % break out if the MAU being considered is worse than existing MAU
                    if currTargetMAU <= MAU(currDesign,currEpoch) && MAU(currDesign,currEpoch) == -1
                        break
                    end
                    if currTargetMAU < MAU(currDesign,currEpoch) && MAU(currDesign,currEpoch) ~= -1
                        break
                    end
                    pathOptions = costpathP{currDesign,currTarget};
                    [~, idx] = sort(pathOptions(:,1));
                    pathOptions = pathOptions(idx,:);
                    for i = 1:size(pathOptions,1)
                        if pathOptions(i,2) < currDuration  % ADDING IN EPOCH DURATION CONSTRAINT HERE
                            unsolved = 0;
                            rulesUsed = cell2mat(rulepathP{currDesign,currTarget});
                            for r = rulesUsed
                                ruleUse(1,r) = ruleUse(1,r) + 1;   % INCREMENT RULE USE COUNT
                            end
                            if any(rulesUsed ~= 6)
                                Cost = Cost + COSTS(currTarget,currEpoch);  % ADD REDESIGN/BUILD COST IF A REDESIGN RULE IS USED
                            end
                            Cost = Cost + pathOptions(i,1);  % ADD IN TRANS $ COST AS WELL
                            transCost = transCost + pathOptions(i,:); % INCREMENT TRANS COSTS ($/time)
                            currDuration = currDuration - pathOptions(i,2);  % REDUCE REMAINING DURATION OF THIS EPOCH
                            currDesign = currTarget;  % CHANGE CURRENT DESIGN TO TARGET
                            designPath = [designPath currDesign];
                            
                            break
                        end
                    end
                    sortedAvailable(end) = [];
                end
            end
            
        elseif remainder == 1  % viable, but min fuel --> max fuel as cheap as possible
            pathOptions = costpathP{currDesign,currDesign-remainder+8};
            [~, idx] = sort(pathOptions(:,1));
            pathOptions = pathOptions(idx,:);
            % by the nature of the data set, we know that that fastest
            % possible transition will always be the first row of this
            % pathOptions, so we dont need to loop, just check the one
            if pathOptions(1,2) < currDuration
                rulesUsed = rulepathP{currDesign,currDesign-remainder+8}{idx(1),:};
                for r = rulesUsed
                    ruleUse(1,r) = ruleUse(1,r) + 1;
                end
                if any(rulesUsed ~= 6)
                    Cost = Cost + COSTS(currDesign-remainder+8,currEpoch);  % ADD REDESIGN/BUILD COST IF A REDESIGN RULE IS USED
                end
                Cost = Cost + pathOptions(1,1);  % ADD IN TRANS $ COST AS WELL
                transCost = transCost + pathOptions(1,:); % INCREMENT TRANS COSTS ($/time)
                currDuration = currDuration - pathOptions(1,2);  % REDUCE REMAINING DURATION OF THIS EPOCH
                currDesign = currDesign-remainder+8;  % CHANGE CURRENT DESIGN TO TARGET
                designPath = [designPath currDesign];
                
                % IF this clause is not activated, the design simply
                % doesn't change
            end
            
        end
        
        % at this point, we have the effective design and duration for this
        % epoch, so we should be able to calculate revenues
        if MAU(currDesign,currEpoch) ~= -1
            Rev = Rev + 250 + 1000*currDuration*MAU(currDesign,currEpoch);  % $200M fixed + $1000M*utility per month
            utilityMonths = utilityMonths + MAU(currDesign,currEpoch)*currDuration;
        end
        % to account for fuel use, downgrade one design number if not at a
        % min fuel design AND was valid for this epoch
        if mod(currDesign,8) ~= 1 && MAU(currDesign,currEpoch) ~= -1
            currDesign = currDesign - 1;
        end
        % add a missed contract if failed
        if MAU(currDesign,currEpoch) == -1
            missedContracts = missedContracts + 1;
        else
            metContracts = metContracts + 1;
        end
        % update paretoPath
        paretoPath = [paretoPath fuzzyParetoNumbers(currDesign,currEpoch)];
        
        
end

while currTime < eraLength
    % pick a random customer (epoch) in present time
    currEpoch = round((numEpochs/2)*(1+rand(1)) + .5);
    epochPath = [epochPath currEpoch];
    % pick a random duration for their need from 1 to 12 months
    currDuration = round(rand(1)*12 + .5);
    currTime = currTime + currDuration;
    
    
            % determine if transition is necessary
        remainder = mod(currDesign,8);  % 1 == min fuel
        if remainder == 0
            remainder = 8;
        end
        currMAU = MAU(currDesign,currEpoch);    % -1 == inviable
        
        if currMAU == -1
            
            % check if maxing fuel will make viable, do that if so
            if MAU(currDesign-remainder+8,currEpoch) ~= -1 && remainder ~= 8
                pathOptions = costpathF{currDesign,currDesign-remainder+8};
                [~, idx] = sort(pathOptions(:,1));
                pathOptions = pathOptions(idx,:);
                % by the nature of the data set, we know that that fastest
                % possible transition will always be the first row of this
                % pathOptions, so we dont need to loop, just check the one
                if pathOptions(1,2) < currDuration
                    rulesUsed = rulepathF{currDesign,currDesign-remainder+8}{idx(1),:};
                    for r = rulesUsed
                        ruleUse(1,r) = ruleUse(1,r) + 1;
                    end
                    if any(rulesUsed ~= 6)
                        Cost = Cost + COSTS(currDesign-remainder+8,currEpoch);  % ADD REDESIGN/BUILD COST IF A REDESIGN RULE IS USED
                    end
                    Cost = Cost + pathOptions(1,1);  % ADD IN TRANS $ COST AS WELL
                    transCost = transCost + pathOptions(1,:); % INCREMENT TRANS COSTS ($/time)
                    currDuration = currDuration - pathOptions(1,2);  % REDUCE REMAINING DURATION OF THIS EPOCH
                    currDesign = currDesign-remainder+8;  % CHANGE CURRENT DESIGN TO TARGET
                    designPath = [designPath currDesign];
                    
                    % IF this clause is not activated, the design simply
                    % doesn't change
                end
               
            else  % IF INVIABLE AND MAXING FUEL DOES NOT FIX
                % find the maxU available viable design
                
                % find available transitions
                available = [];
                for d2 = 1:numDesigns
                    if ~isempty(costpathF{currDesign,d2})
                        available = [available d2];
                    end
                end
                % find avaiable design with highest MAU
                availableMAU = MAU(available,currEpoch);
                [sortedMAU indices] = sort(availableMAU); % sorts largest = last
                sortedAvailable = available(indices);
                
                % designate as unsolved and loop until solved
                unsolved = 1;
                while unsolved
                    if isempty(sortedAvailable)
                        break
                    end
                    currTarget = sortedAvailable(end);
                    currTargetMAU = sortedMAU(end);
                    % break out if the MAU being considered is worse than existing MAU
                    if currTargetMAU <= MAU(currDesign,currEpoch) && MAU(currDesign,currEpoch) == -1
                        break
                    end
                    if currTargetMAU < MAU(currDesign,currEpoch) && MAU(currDesign,currEpoch) ~= -1
                        break
                    end
                    pathOptions = costpathF{currDesign,currTarget};
                    [~, idx] = sort(pathOptions(:,1));
                    pathOptions = pathOptions(idx,:);
                    for i = 1:size(pathOptions,1)
                        if pathOptions(i,2) < currDuration  % ADDING IN EPOCH DURATION CONSTRAINT HERE
                            unsolved = 0;
                            rulesUsed = cell2mat(rulepathF{currDesign,currTarget});
                            for r = rulesUsed
                                ruleUse(1,r) = ruleUse(1,r) + 1;   % INCREMENT RULE USE COUNT
                            end
                            if any(rulesUsed ~= 6)
                                Cost = Cost + COSTS(currTarget,currEpoch);  % ADD REDESIGN/BUILD COST IF A REDESIGN RULE IS USED
                            end
                            Cost = Cost + pathOptions(i,1);  % ADD IN TRANS $ COST AS WELL
                            transCost = transCost + pathOptions(i,:); % INCREMENT TRANS COSTS ($/time)
                            currDuration = currDuration - pathOptions(i,2);  % REDUCE REMAINING DURATION OF THIS EPOCH
                            currDesign = currTarget;  % CHANGE CURRENT DESIGN TO TARGET
                            designPath = [designPath currDesign];
                            
                            break
                        end
                    end
                    sortedAvailable(end) = [];
                end
            end
            
        elseif remainder == 1  % viable, but min fuel --> max fuel as cheap as possible
            pathOptions = costpathF{currDesign,currDesign-remainder+8};
            [~, idx] = sort(pathOptions(:,1));
            pathOptions = pathOptions(idx,:);
            % by the nature of the data set, we know that that fastest
            % possible transition will always be the first row of this
            % pathOptions, so we dont need to loop, just check the one
            if pathOptions(1,2) < currDuration
                rulesUsed = rulepathF{currDesign,currDesign-remainder+8}{idx(1),:};
                for r = rulesUsed
                    ruleUse(1,r) = ruleUse(1,r) + 1;
                end
                if any(rulesUsed ~= 6)
                    Cost = Cost + COSTS(currDesign-remainder+8,currEpoch);  % ADD REDESIGN/BUILD COST IF A REDESIGN RULE IS USED
                end
                Cost = Cost + pathOptions(1,1);  % ADD IN TRANS $ COST AS WELL
                transCost = transCost + pathOptions(1,:); % INCREMENT TRANS COSTS ($/time)
                currDuration = currDuration - pathOptions(1,2);  % REDUCE REMAINING DURATION OF THIS EPOCH
                currDesign = currDesign-remainder+8;  % CHANGE CURRENT DESIGN TO TARGET
                designPath = [designPath currDesign];
                
                % IF this clause is not activated, the design simply
                % doesn't change
            end
            
        end
        
        % at this point, we have the effective design and duration for this
        % epoch, so we should be able to calculate revenues
        if MAU(currDesign,currEpoch) ~= -1
            Rev = Rev + 250 + 1000*currDuration*MAU(currDesign,currEpoch);  % $200M fixed + $1000M*utility per month
            utilityMonths = utilityMonths + MAU(currDesign,currEpoch)*currDuration;
        end
        % to account for fuel use, downgrade one design number if not at a
        % min fuel design AND was valid for this epoch
        if mod(currDesign,8) ~= 1 && MAU(currDesign,currEpoch) ~= -1
            currDesign = currDesign - 1;
        end
        % add a missed contract if failed
        if MAU(currDesign,currEpoch) == -1
            missedContracts = missedContracts + 1;
        else
            metContracts = metContracts + 1;
        end
        %update paretoPath
        paretoPath = [paretoPath fuzzyParetoNumbers(currDesign,currEpoch)];
        
end



% process paretoPath
worstPareto = max(paretoPath);
bestPareto = min(paretoPath);
avgPareto = mean(paretoPath);
avgParetoNoFail = mean(paretoPath(paretoPath ~= 101));


end